/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.particle;

import java.util.Random;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleGusterSandSpin
extends SpriteTexturedParticle {
    private float targetX;
    private float targetY;
    private float targetZ;
    private float distX;
    private float distZ;
    private static final int[] POSSIBLE_COLORS = new int[]{15975305, 15709560, 16307354, 16770733, 0xFFFFCD};
    private static final int[] POSSIBLE_COLORS_RED = new int[]{13988150, 13000999, 12343841, 11686939, 10963729};
    private static final int[] POSSIBLE_COLORS_SOUL = new int[]{5456440, 5127475, 4009509, 4798252, 2826267};

    private ParticleGusterSandSpin(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, int variant) {
        super(world, x, y, z);
        int color = ParticleGusterSandSpin.selectColor(variant, this.field_187136_p);
        float lvt_18_1_ = (float)(color >> 16 & 0xFF) / 255.0f;
        float lvt_19_1_ = (float)(color >> 8 & 0xFF) / 255.0f;
        float lvt_20_1_ = (float)(color & 0xFF) / 255.0f;
        this.func_70538_b(lvt_18_1_, lvt_19_1_, lvt_20_1_);
        this.targetX = (float)motionX;
        this.targetY = (float)motionY;
        this.targetZ = (float)motionZ;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.field_70544_f *= 0.4f + this.field_187136_p.nextFloat() * 1.4f;
        this.field_70547_e = 15 + this.field_187136_p.nextInt(15);
        this.distX = (float)(x - (double)this.targetX);
        this.distZ = (float)(z - (double)this.targetZ);
    }

    public static int selectColor(int variant, Random rand) {
        if (variant == 2) {
            return POSSIBLE_COLORS_SOUL[rand.nextInt(POSSIBLE_COLORS_SOUL.length - 1)];
        }
        if (variant == 1) {
            return POSSIBLE_COLORS_RED[rand.nextInt(POSSIBLE_COLORS_RED.length - 1)];
        }
        return POSSIBLE_COLORS[rand.nextInt(POSSIBLE_COLORS.length - 1)];
    }

    public void func_189213_a() {
        super.func_189213_a();
        float radius = 2.0f;
        float angle = this.field_70546_d * 2;
        double extraX = this.targetX + radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = this.targetZ + radius * MathHelper.func_76134_b((float)angle);
        double d2 = extraX - this.field_187126_f;
        double d3 = (double)this.targetY - this.field_187127_g;
        double d4 = extraZ - this.field_187128_h;
        float speed = 0.02f;
        this.field_187129_i += d2 * (double)speed;
        this.field_187130_j += d3 * (double)speed;
        this.field_187131_k += d4 * (double)speed;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactorySoul
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FactorySoul(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleGusterSandSpin p = new ParticleGusterSandSpin(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 2);
            p.func_217568_a(this.spriteSet);
            return p;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactoryRed
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FactoryRed(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleGusterSandSpin p = new ParticleGusterSandSpin(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 1);
            p.func_217568_a(this.spriteSet);
            return p;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleGusterSandSpin p = new ParticleGusterSandSpin(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 0);
            p.func_217568_a(this.spriteSet);
            return p;
        }
    }
}

